import matplotlib.pyplot as plt
import numpy as np

f = open('mutation type.txt')
line = [i.strip() for i in f.readlines()]
f.close()

total = [float(i) for i in line[0].split('\t')]
insertion = [float(i) for i in line[1].split('\t')]
ins_enlar = [float(i) for i in line[1].split('\t')[1:]]
deletion = [float(i) for i in line[2].split('\t')]

def pie():
	fig, ax = plt.subplots(figsize=(3,3))
	ax.pie(total)
	plt.savefig('mutation_type_total.pdf',format='pdf')
	plt.show()

def bar():
	fig = plt.figure(figsize=(10,3))
	gs = fig.add_gridspec(1, 2, wspace=0)
	ax1, ax2 = gs.subplots(sharey=True)
	ax1.bar(range(1,len(insertion)+1),insertion)
	ax2.bar(range(1,len(deletion)+1),deletion)
	plt.savefig('ins_del.pdf',format='pdf')
	plt.show()


def bar_enlar():
	fig, ax = plt.subplots(figsize=(5,3))
	ax.bar(range(1,len(ins_enlar)+1),ins_enlar)
	plt.savefig('ins_enlar.pdf', format='pdf')
	plt.show()

bar_enlar()